import numpy as np
import copy
from ACState.object_dict import ObjDict

            # control_freq, var_horizon, num_obstacles, standard_reward, \
            # goal_reward, obstacle_reward, out_of_bounds_reward, mode,\
            # cube_halfsize, goal_radius

arg_list = ["control_freq", "var_horizon", "num_obstacles", "standard_reward",
            "goal_reward", "obstacle_reward", "out_of_bounds_reward", "mode",
            "hard_obstacles", "cube_halfsize", "goal_radius"]

def to_tuple(args):
    return tuple((args[n] for n in arg_list))

default = ObjDict(dict(control_freq = 2,
                       var_horizon = 1000, 
                       num_obstacles = 0, 
                       standard_reward =-0.1,
                       goal_reward = 10, 
                       obstacle_reward = -3, 
                       out_of_bounds_reward = -3, 
                       mode = 0,
                       hard_obstacles=False,
                       cube_halfsize = 0.015,
                       goal_radius = 0.05))

obstacles_many = copy.deepcopy(default)
obstacles_many.num_obstacles = 15
obstacles_many.out_of_bounds_reward = -2
obstacles_many.obstacle_reward = -2

obstacles = copy.deepcopy(default)
obstacles.num_obstacles = 10

joint = copy.deepcopy(obstacles_many)
joint.mode = 1

hard = copy.deepcopy(obstacles_many)
hard.hard_obstacles = True

small = copy.deepcopy(default)
small.cube_halfsize = 0.007

hard_few = copy.deepcopy(default)
hard_few.cube_halfsize = 0.015
hard_few.hard_obstacles = True
hard_few.num_obstacles = 2


planar = copy.deepcopy(obstacles_many)
planar.mode = 3

discrete = copy.deepcopy(default)
discrete.mode = 4

discrete_obs = copy.deepcopy(discrete)
discrete_obs.num_obstacles = 15
discrete_obs.out_of_bounds_reward = -2
discrete_obs.obstacle_reward = -2




variants = {
    "default": to_tuple(default),
    "small": to_tuple(small),
    "obstacles": to_tuple(obstacles),
    "obstacles_many": to_tuple(obstacles_many),
    "joint": to_tuple(joint),
    "hard": to_tuple(hard),
    "hard_few": to_tuple(hard_few),
    "planar": to_tuple(planar),
    "discrete": to_tuple(discrete),
    "discrete_obs": to_tuple(discrete_obs),
}

ranges_fixed = {
    "Action": [np.array([-1,-1,-1]).astype(np.float64), np.array([1,1,1]).astype(np.float64)],
    "Gripper": [np.array([-0.3, -0.31, .80]).astype(np.float64), np.array([0.2, 0.21, 1]).astype(np.float64)],
    "Target": [np.array([-0.3, -0.31, .80]).astype(np.float64), np.array([0.2, 0.21, 1]).astype(np.float64)],
    "Obstacle": [np.array([-0.3, -0.31, .80]).astype(np.float64), np.array([0.2, 0.21, 1]).astype(np.float64)],
    "Goal": [np.array([-0.3, -0.31]).astype(np.float64), np.array([0.2, 0.21]).astype(np.float64)],
    "Done": [np.array([0]).astype(np.float64), np.array([1]).astype(np.float64)],
    "Reward": [np.array([-100]).astype(np.float64), np.array([100]).astype(np.float64)]
}

dynamics_fixed = {
    "Action": [np.array([-2,-2,-2]).astype(np.float64), np.array([2,2,2]).astype(np.float64)],
    "Gripper": [np.array([-0.05, -0.05, -0.05]).astype(np.float64), np.array([0.05, 0.05, 0.05]).astype(np.float64)],
    "Target": [np.array([-0.05, -0.05, -.05]).astype(np.float64), np.array([0.05, 0.05, 0.05]).astype(np.float64)],
    "Obstacle": [np.array([-0.05, -0.05, -.05]).astype(np.float64), np.array([0.05, 0.05, 0.05]).astype(np.float64)],
    "Goal": [np.array([-0.05, -0.05]).astype(np.float64), np.array([0.05, 0.05]).astype(np.float64)],
    "Done": [np.array([0]).astype(np.float64), np.array([1]).astype(np.float64)],
    "Reward": [np.array([-100]).astype(np.float64), np.array([100]).astype(np.float64)]
}


ranges = {
    "Action": [np.array([-1,-1,-1]).astype(np.float64), np.array([1,1,1]).astype(np.float64)],
    "Gripper": [np.array([-0.3, -0.2, .831]).astype(np.float64), np.array([0.1, 0.2, 1]).astype(np.float64)],
    "Target": [np.array([-0.2, -0.31, .82]).astype(np.float64), np.array([0.2, 0.21, .84]).astype(np.float64)],
    "Obstacle": [np.array([-0.22, -0.12, .80]).astype(np.float64), np.array([0.02, 0.12, 0.81]).astype(np.float64)],
    "Goal": [np.array([-0.2, -0.31]).astype(np.float64), np.array([0.2, 0.21]).astype(np.float64)],
    "Done": [np.array([0]).astype(np.float64), np.array([1]).astype(np.float64)],
    "Reward": [np.array([-100]).astype(np.float64), np.array([100]).astype(np.float64)]
}

dynamics = {
    "Action": [np.array([-2,-2,-2]).astype(np.float64), np.array([2,2,2]).astype(np.float64)],
    "Gripper": [np.array([-0.05, -0.05, -0.03]).astype(np.float64), np.array([0.05, 0.05, 0.03]).astype(np.float64)],
    "Target": [np.array([-0.05, -0.05, -.05]).astype(np.float64), np.array([0.05, 0.05, 0.05]).astype(np.float64)],
    "Obstacle": [np.array([0, 0, 0]).astype(np.float64), np.array([0, 0, 0]).astype(np.float64)],
    "Goal": [np.array([0, 0]).astype(np.float64), np.array([0, 0]).astype(np.float64)],
    "Done": [np.array([0]).astype(np.float64), np.array([1]).astype(np.float64)],
    "Reward": [np.array([-100]).astype(np.float64), np.array([100]).astype(np.float64)]
}


position_masks = {
    "Action": np.array([0,0,0]),
    "Gripper":np.array([1,1,1]),
    "Target": np.array([1,1,1]),
    "Obstacle": np.array([1,1,1]),
    "Goal": np.array([1,1]),
    "Done": np.array([0]),
    "Reward": np.array([0]),
}

instanced = {
    "Action": 1,
    "Gripper":1,
    "Target": 1,
    "Obstacle": 20,
    "Goal": 1,
    "Done": 1,
    "Reward": 1
}

discrete_ranges = copy.deepcopy(ranges)
discrete_ranges["Action"] = [np.array([0]), np.array([5])]
discrete_dynamics = copy.deepcopy(dynamics)
discrete_dynamics["Action"] = [np.array([-5]), np.array([5])]
discrete_position_masks = copy.deepcopy(position_masks)
discrete_position_masks["Action"] = np.array([0])